/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ClientStuff;
import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SnowParticle
extends WeatherParticle {
    float rotationAmount;

    protected SnowParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.f_107663_ = ParticleRainClient.config.snow.size;
        this.f_107226_ = ParticleRainClient.config.snow.gravity;
        this.f_107216_ = -this.f_107226_;
        this.m_108337_(Minecraft.m_91087_().f_91061_.f_107296_.m_118316_(new ResourceLocation("particlerain", "snow" + this.f_107223_.m_188503_(4))));
        this.f_107215_ = level.m_46470_() ? (double)(this.f_107226_ * ParticleRainClient.config.snow.stormWindStrength) : (double)(this.f_107226_ * ParticleRainClient.config.snow.windStrength);
        if (ParticleRainClient.config.yLevelWindAdjustment) {
            this.f_107215_ *= ClientStuff.yLevelWindAdjustment(y);
        }
        this.f_107217_ = this.f_107215_;
        this.rotationAmount = level.m_213780_().m_188499_() ? 1.0f : -1.0f;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (!this.f_107208_.m_6425_(this.pos.m_7495_()).m_76178_()) {
            this.f_107230_ = 0.0f;
        } else if (!this.f_107208_.m_6425_(this.pos.m_6625_(2)).m_76178_()) {
            double distanceToWater = this.pos.m_6625_(2).m_123342_() - this.pos.m_123342_();
            this.f_107230_ = (float)Math.abs(distanceToWater) / 2.0f;
        }
        this.f_107204_ = this.f_107231_;
        this.f_107231_ = this.f_107204_ + (this.f_107208_.m_46470_() ? ParticleRainClient.config.snow.stormRotationAmount : ParticleRainClient.config.snow.rotationAmount) * this.rotationAmount;
        if (this.f_107218_ || this.removeIfObstructed()) {
            this.m_107274_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SnowParticle(level, x, y, z);
        }
    }
}

